import pandas as pd   
import pickle
from decision_company import read_csv_file, avg, locate_mode, get_max, get_min_value, calculate_median

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Descriptive statistics for age  
age_column = credit_customers['age']  
age_mean = avg(age_column)  
age_median = calculate_median(credit_customers, 'age')  
age_mode = locate_mode(age_column)[0]  
age_range = get_max(age_column) - get_min_value(age_column) 
  
print(f"Age - Mean: {age_mean}, Median: {age_median}, Mode: {age_mode}, Range: {age_range}")  
pickle.dump(age_mean, open("./ref_result/age_mean.pkl","wb"))
pickle.dump(age_median, open("./ref_result/age_median.pkl","wb"))
pickle.dump(age_mode, open("./ref_result/age_mode.pkl","wb"))
pickle.dump(age_range, open("./ref_result/age_range.pkl","wb"))

  